if(typeof eyeJ == "undefined") {
	eyeJ = {
		apps: {},
		end: function (checknum) {
			if(typeof eyeJ.apps[checknum] == "undefined") return;
			// stop the thread
			eyeJ.apps[checknum].thread.end();
			// clean up any ui
			var UI = eyeJ.apps[checknum].eyeX_UI;
			for(var name in UI) {
				try{
					var d = document.getElementById(name);
					d.parentNode.removeChild(d);
				} catch(e) {}
			}
			// kill the data
			delete eyeJ.apps[checknum];
			
		},
		Path: "index.php?version="+EXTERN_CACHE_VERSION+"&extern=apps/eyeJ",
		Thread: function (path) {
			var self = this;
			this._worker = new Worker(path);
			this.actions = {};
			this.end = function () { // kill the worker
				this._worker.terminate();
			};
			this.eval = function (code) {
				code = "  \n"+code;
				this._worker.postMessage(code);
			};
			this.unSafe = function (code) {
				code = "@ \n" + code;
				this._worker.postMessage(code);
			};
			this.loadActions = function () {
				var load = "";
				for(var n in this.actions) {
					load += ";_NEWFUNCTION(\""+n+"\");"
				}
				this._worker.postMessage("@\n"+load);
			};
			this._worker.onmessage = function (event) {
				var data = event.data,
					loc = data.indexOf(":"),
					name = data.substring(0, loc);
				data = JSON.parse(data.substring(loc+1));
				if(self.actions[name])
					self.actions[name](data);
			};
		},
		setUpThread: function (FilePath, FileName) {
			var t = new eyeJ.Thread(eyeJ.Path+"/worker.js");
			t.actions = eyeJ.actions;
			t.unSafe('OBJJ_INCLUDE_PATHS = ["'+eyeJ.Path+'", "'+FilePath+'"];');
			t.unSafe('OBJJ_MAIN_FILE = "'+FileName+'";');
			var import = 'if(typeof JSON == "undefined") importScripts("'+eyeJ.Path+'/json.js");\n' 
						+ 'importScripts("'+eyeJ.Path+'/Objective-J.js");';
			t.unSafe(import);
			return t;
		},
		actions: {
			alert: function (p) { alert(p[1]); },
			_MessageServer: function (p) {
				eyeJ.SendMessage(p[0].checknum, p[1], p[2] || "");
			},
			_SELF_terminate_: function (p) {
				eyeJ.end(p[0].checknum);
			},
			'-error-': function (d) {
				if(console.error) {
					console.error("eyeJ error\n" + JSON.stringify(d));
				}
				//alert("error:\n"+JSON.stringify(d));
			},
			_EYEX_SEND_XML_: function(d) {
				var xml = d[1];
				var xmlDoc;
				try {
					xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
					xmlDoc.async="false";
					xmlDoc.loadXML(xml);
				} catch(e) {
					var parser=new DOMParser();
					parser.async="false";
					xmlDoc=parser.parseFromString(xml,"text/xml");
				} 
				localEngine(xmlDoc);
			},
			_EYEX_ADD_NAME_: function (d) {
				eyeJ.apps[d[0].checknum].eyeX_UI[d[1]] = true;
			}
		},
		sync: function () {
			var out = {};
			for(var a = 0; a < arguments.length; a++) {
				try {
					var i = arguments[a];
					out[i] = document.getElementById(i).value;
				}catch (e) {}
			}
			out = JSON.stringify(out);
			return out;
		}
	};
	function eyeJ_load () {
		if(typeof window.eyeJLoadPid != "undefined") {
			if(typeof eyeJ.apps[window.eyeJLoadPid] == "undefined") {
				eyeJ.apps[window.eyeJloadCheckNum] = {
					thread: eyeJ.setUpThread(window.eyeJLoadFilePath, window.eyeJLoadFileName),
					checknum: window.eyeJloadCheckNum,
					pid: window.eyeJLoadPid,
					path: window.eyeJLoadFilePath,
					file: window.eyeJLoadFileName,
					eyeX_UI: {},
					event: function (name, data) {
						this.thread.unSafe("_eyeosEventManager(\""+name+"\","+JSON.stringify(data)+");");
					}
				};
				var t = eyeJ.apps[window.eyeJloadCheckNum].thread;
				t.unSafe('_INFO_ = {pid: "'+window.eyeJLoadPid+'", checknum:"'+window.eyeJloadCheckNum+'"};');
				t.loadActions();
			}
			delete window.eyeJLoadPid;
			delete window.eyeJloadCheckNum;
			delete window.eyeJLoadFilePath;
			delete window.eyeJLoadFileName;
		}
	}
	eyeJ.SendMessage = window.sendMsg;
	window.sendMsg = function (checknum, msg, prams) {
		if(typeof eyeJ.apps[checknum] == "undefined") {
			return eyeJ.SendMessage(checknum, msg, prams);
		}
		// running in eyeJ
		/*if(msg.indexOf("Server") != -1 || msg == "Event") {
			return eyeJ.SendMessage(checknum, msg, prams);
		}*/
		// send the message to the code sandbox
		eyeJ.apps[checknum].event(msg, prams);
	};
	if(typeof JSON == "undefined") {
		dhtmlLoadScript(eyeJ.Path+"/json.js");
	}
}

eyeJ_load();