@import <eyeos/ui/base.j>
@import <json.j>

@implementation Textbox : uiBase
{
 var Prams;
}

-(id) init
{
 [super init];
 Prams = {
  "text":"",
  "visible":1,
  "enabled":1,
  "password":0,
  "width":150,
  "noborder":0
 };
 return self;
}

-(CPString) showGetPrams
{
 Prams.sync = [self makeSyncList];
 return [json toString:Prams]; 
}

-(void) setPrams:(CPString)key to:(var)d
{
 if(typeof d == "string") d = d.toString();
 Prams[key] = d;
}

-(CPString) eyeXWidgetName
{
 return "Textbox";
}

-(void) text:(CPString)_text
{
 [self setPrams:"text" to:_text];
 if([self showing]) {
  [eyeX rawjs:"document.getElementById(\""+[self getName]+"\").value=\""+[eyeX jsSafe:_text]+"\""];
 }
}

-(CPString) text
{
 return [self eventInfo];
}

-(void) password:(BOOL)_b
{
 [self setPrams:"password" to:_b*1];
}

-(void) width:(CPNumber)widt
{
 [self setPrams:"width" to:widt];
}

-(void) border:(BOOL)_b
{
 [self setPrams:"noborder" to:(!_b)*1];
}

-(void) focus
{
 if([self showing]) {
  [eyeX rawjs:"document.getElementById(\""+[self getName]+"\").focus();"];
 }
}

@end